<?php
/**
 * Created by PhpStorm.
 * User: asus
 * Date: 11/08/23
 * Time: 16:20
 */

require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/models/avaluo_documentacion_get.model.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/models/catalogos.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/libs/fechas.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/libs/enigma.php";
class avaluoDocumentacionGetController{

    #New
    static public $cveavaluo;

    /*===========================
     * Get Documentos del avalúo
     *===========================*/

    static public function getURLDocumentosAval($folioUV){
        $documentos = array();
        $resDocs = avaluoDocumentacionGetModel::getDocumentosAval($folioUV);
        //var_dump($resDocs);
        $j = 0;
        foreach ($resDocs as $i => $doc){

            /*
            //Codificamos el folio UV (Folio sisval)
            $folioUVCode = Enigma::encrypt($doc->_cveavaluo);
            
            //Codificamos el tipo de documento
            $tipoDocCode = Enigma::encrypt($doc->_cvedocumento_tipo_bbva);

            //Codificamos el cvedocumento
            $cvedocumentoCode = Enigma::encrypt($doc->cvedocumento);
            $cvedocumentoCode = $doc->cvedocumento;
            */

            //Armamos el enlace al documento
            //$url = "https://sisval.com.mx/sisval3/ws/docsbbva/docbbva.php?id=$cvedocumentoCode&folio=$folioUVCode&tipoDoc=$tipoDocCode";
            //$url = "https://sisval.com.mx/sisval3/ws/docsbbva/docbbva.php?id=$cvedocumentoCode";

            $tipodocs = Catalogos::getCatTipoDocs();

            $documentos[$i]["enlace"]           = $doc->documento_url_firmada;
            $documentos[$i]["enlace_vigencia"]  = $doc->documento_url_firmada_expira;
            $documentos[$i]["extension"]        = $doc->documento_extension;
            $documentos[$i]["tipos_id"]         = $doc->_cvedocumento_tipo_bbva;
        
            if($doc->documento_comentarios != ""){
                $documentos[$i]["descripcion"]      = self::eliminar_acentos($doc->documento_comentarios);
            }else{
            
                if($doc->documento_desc != "")
                    $documentos[$i]["descripcion"]      = self::eliminar_acentos($doc->documento_desc);
                else
                    $documentos[$i]["descripcion"]      = self::eliminar_acentos($tipodocs[$doc->_cvedocumento_tipo_bbva]);
            }
          
        }
        return $documentos;
    }

    private static function eliminar_acentos($cadena){

        //Reemplazamos la A y a
        $cadena = str_replace(
            array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª'),
            array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a'),
            $cadena
        );

        //Reemplazamos la E y e
        $cadena = str_replace(
            array('É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê'),
            array('E', 'E', 'E', 'E', 'e', 'e', 'e', 'e'),
            $cadena );

        //Reemplazamos la I y i
        $cadena = str_replace(
            array('Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î'),
            array('I', 'I', 'I', 'I', 'i', 'i', 'i', 'i'),
            $cadena );

        //Reemplazamos la O y o
        $cadena = str_replace(
            array('Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô'),
            array('O', 'O', 'O', 'O', 'o', 'o', 'o', 'o'),
            $cadena );

        //Reemplazamos la U y u
        $cadena = str_replace(
            array('Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û'),
            array('U', 'U', 'U', 'U', 'u', 'u', 'u', 'u'),
            $cadena );

        //Reemplazamos la N, n, C y c
        $cadena = str_replace(
            array('Ñ', 'ñ', 'Ç', 'ç'),
            array('N', 'n', 'C', 'c'),
            $cadena
        );

        return $cadena;
    }
}
