<?php
/**
 * Created by PhpStorm.
 * User: asus
 * Date: 11/08/23
 * Time: 16:20
 */

require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/models/avaluo_fotografias_get.model.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/models/catalogos.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/libs/fechas.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/libs/enigma.php";

class avaluoFotografiasGetController{

    #New
    static public $cveavaluo;
    
    /*======================
     * Get Fotos del avalúo
     *======================*/

    static public function getURLFotosAval($folioUV){
        $fotografias = array();
        $resFotos = avaluoFotografiasGetModel::getURLFotosAval($folioUV);
        //var_dump($resFotos);
        $tipoFotos = Catalogos::getFotografiasTipo();
        $j = 0;
        foreach ($resFotos as $i => $foto){
        
            $fotografias[$i]["enlace"]           = $foto->foto_url_firmada;
            $fotografias[$i]["enlace_vigencia"]  = $foto->foto_url_firmada_expira;
            $fotografias[$i]["extension"]        = $foto->foto_extension;
            $fotografias[$i]["tipos_id"]         = $foto->_cvefoto_tipo_bbva;
        
            if($foto->foto_comentarios != ""){
                $fotografias[$i]["descripcion"]      = self::eliminar_acentos($foto->foto_comentarios);
            }else{

                $fotografias[$i]["descripcion"]      = self::eliminar_acentos($tipoFotos[$foto->_cvefoto_tipo_bbva]);
            }
          
        }
        return $fotografias;
    }
    
    private static function eliminar_acentos($cadena){

        //Reemplazamos la A y a
        $cadena = str_replace(
            array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª'),
            array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a'),
            $cadena
        );

        //Reemplazamos la E y e
        $cadena = str_replace(
            array('É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê'),
            array('E', 'E', 'E', 'E', 'e', 'e', 'e', 'e'),
            $cadena );

        //Reemplazamos la I y i
        $cadena = str_replace(
            array('Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î'),
            array('I', 'I', 'I', 'I', 'i', 'i', 'i', 'i'),
            $cadena );

        //Reemplazamos la O y o
        $cadena = str_replace(
            array('Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô'),
            array('O', 'O', 'O', 'O', 'o', 'o', 'o', 'o'),
            $cadena );

        //Reemplazamos la U y u
        $cadena = str_replace(
            array('Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û'),
            array('U', 'U', 'U', 'U', 'u', 'u', 'u', 'u'),
            $cadena );

        //Reemplazamos la N, n, C y c
        $cadena = str_replace(
            array('Ñ', 'ñ', 'Ç', 'ç'),
            array('N', 'n', 'C', 'c'),
            $cadena
        );

        return $cadena;
    }
    
}