<?php
/**
 * Created by PhpStorm.
 * User: server
 * Date: 1/07/23
 * Time: 04:47 PM
 */

require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/models/login.model.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/libs/jwt-utils.php";

class LoginController{

    static public function login($username, $passwd)
    {
        $response = LoginModel::login($username, $passwd);
        return $response;
    }

    static public function saveToken($id, $token, $token_exp)
    {
        $response = LoginModel::saveToken($id, $token, $token_exp);
        return $response;
    }

    static public function validaToken()
    {
        //Get Bearer token
        $bearer_token = get_bearer_token();
        $is_jwt_valid = is_jwt_valid($bearer_token, 'dfhsdfg34dchs4xgsrsdry46');

        if (!$is_jwt_valid) {
            $json = array(
                "code" => 401,
                "message" => "TOKEN_INVALIDO",
                "data" => null
            );
            return array(false, $json);
        }

        //Validamos si está en tiempo
        $response = LoginModel::getExpTimeToken($bearer_token);
        if (count($response) > 0) {
            $time = time();
            if ($response[0]->token_exp > $time)
                return array(true, '');
            else {
                $json = array(
                    "code" => 401,
                    "message" => "TOKEN_INVALIDO.",
                    "data" => null
                );
                return array(false, $json);
            }
        } else {
            $json = array(
                "code" => 401,
                "message" => "TOKEN_INVALIDO..",
                "data" => null
            );
            return array(false, $json);
        }
    }
}
