<?php

namespace Sabre\DAVACL;

use Sabre\DAV;

class MockPrincipal extends DAV\Node implements IPrincipal {

    public $name;
    public $principalUrl;
    public $groupMembership = [];
    public $groupMemberSet = [];

    function __construct($name, $principalUrl, array $groupMembership = [], array $groupMemberSet = []) {

        $this->name = $name;
        $this->principalUrl = $principalUrl;
        $this->groupMembership = $groupMembership;
        $this->groupMemberSet = $groupMemberSet;

    }

    function getDisplayName() {

        return $this->getName();

    }

    function getName() {

        return $this->name;

    }

    function getAlternateUriSet() {

        return [];

    }

    function getPrincipalUrl() {

        return $this->principalUrl;

    }

    function getGroupMemberSet() {

        return $this->groupMemberSet;

    }

    function setGroupMemberSet(array $groupMemberSet) {

        $this->groupMemberSet = $groupMemberSet;

    }

    function getGroupMemberShip() {

        return $this->groupMembership;

    }
}
