<?php

namespace Sabre\VObject\Property\ICalendar;

use PHPUnit_Framework_TestCase;
use Sabre\VObject\Component\VCalendar;

class CalAddressTest extends PHPUnit_Framework_TestCase {

    /**
     * @dataProvider values
     */
    function testGetNormalizedValue($expected, $input) {

        $vobj = new VCalendar();
        $property = $vobj->add('ATTENDEE', $input);

        $this->assertEquals(
            $expected,
            $property->getNormalizedValue()
        );

    }

    function values() {

        return [
            ['mailto:a@b.com', 'mailto:a@b.com'],
            ['mailto:a@b.com', 'MAILTO:a@b.com'],
            ['/foo/bar', '/foo/bar'],
        ];

    }

}
