<?php
/**
 * Created by PhpStorm.
 * User: server
 * Date: 2/07/23
 * Time: 04:00 AM
 */

require_once "conection.php";
require_once "catalogos.php";
class aceptarIncidenciaSetModel{

    static public $pdo;
    
    /***********************
     * Estatus Incidencias:
     * 0 = Dado de alta en valor
     * 1 = Reportado a BBVA
     * 2 = Incidencia aceptada por BBVA
     * 3 = Incidencia rechazada por BBVA
     ************************/
    static public function saveAceptarIncidencia($folioUV,$detalle,$hoy){

        //New Get Folio UT
        $folioUT = self::getFolioUT($folioUV);

        //New Get Folio Sisval
        aceptarIncidenciaSetController::$cveavaluo = self::getFoliosisval($folioUV);
       
        //Get solicitud
        $cvesolicitud = self::getCveSolicitud($folioUT);
        if(empty($cvesolicitud))
            return array(false,1);

        aceptarIncidenciaSetController::$cveavaluo = self::getFoliosisvalBySolicitud($cvesolicitud);

        //Obtenemos el id de la incidencia
        #New
        $cvesolicitud_incidencia = self::getUltimaIncidencia($cvesolicitud);

        $sql = "
            UPDATE  bbva_solicitud_incidencias
            SET     solicitud_incidencia_detalle_banco = '$detalle',
                    solicitud_incidencia_fecha_banco = '$hoy',
                    solicitud_incidencia_status = '2'
            WHERE   cvesolicitud_incidencia = '$cvesolicitud_incidencia'
            AND     solicitud_incidencia_status IN ('1','2')
        ";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        if($stmt->rowCount()>0)
            return array(true);
        return array(false,2);
    }

    #Existe Folio UT (Solicitud)
    static private function getCveSolicitud($folioUT){
        $sql = "
            SELECT  cvesolicitud
            FROM    bbva_solicitudes
            WHERE   folio = '$folioUT'
        ";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->cvesolicitud;
    }

    #Existe Folio sisval
    static public function getFoliosisvalBySolicitud($cvesolicitud){
        $sql = "
            SELECT  _cveavaluo
            FROM    datos_bancomer
            WHERE   _cvesolicitud = '$cvesolicitud'
        ";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->_cveavaluo;
    }

    #New
    static public function getFolioUT($cveavaluo){
        $sql = "
            SELECT  folio
            FROM    bbva_solicitudes
            WHERE   _cveavaluo2 = '$cveavaluo'
        ";
        //echo $sql;
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->folio;
    }

    #New
    static public function getFoliosisval($folioUT){
        $sql = "
            SELECT  _cveavaluo
            FROM    bbva_solicitudes
            WHERE   folio = '$folioUT'
        ";
        //echo $sql;
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->_cveavaluo;
    }

    /*===============================================================
     * Para determinar la última incidencia generada de la solicitud
     *===============================================================*/
    #New
    static public function getUltimaIncidencia($cvesolicitud){
        try{

            if(self::$pdo == "")
                self::$pdo = Conection::connect();

            $sql = "
                SELECT    cvesolicitud_incidencia
                FROM      bbva_solicitud_incidencias
                WHERE     _cvesolicitud = '$cvesolicitud'
                ORDER BY  cvesolicitud_incidencia DESC
                LIMIT     0,1
            ";
            $stmt = self::$pdo->prepare($sql);
            $stmt->execute();
            return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->cvesolicitud_incidencia;
        }catch (PDOException $e){
            return false;
        }
    }
}
