<?php
/**
 * Created by PhpStorm.
 * User: server
 * Date: 1/07/23
 * Time: 08:52 PM
 */

$routesArray = explode("/",$_SERVER['REQUEST_URI']);
$routesArray = array_filter($routesArray);

//var_dump($routesArray);

/*=========================================
 * Cuando no se hacen peticiones a la api
 *=========================================*/

if(count($routesArray) == 0){

    $json = array(
        'code' => 404,
        'message' => 'API_ERROR_PETICION_INCORRECTA',
        'data' => null
    );
    echo json_encode($json,http_response_code($json["code"]));
    return;
}

/*========================================
 * Cuando si se hacen peticiones a la api
 *========================================*/

if(count($routesArray) > 0 && isset($_SERVER['REQUEST_METHOD'])){

    /*================
     * Peticiones GET
     *===============*/

    if($_SERVER['REQUEST_METHOD'] == "GET"){
        include "services/get.php";
    }

    /*================
     * Peticiones POST
     *===============*/

    if($_SERVER['REQUEST_METHOD'] == "POST"){
        include "services/post.php";
    }

    /*=========================================
     * Si el metodo es diferente a POST y GET
     *=========================================*/

    if($_SERVER['REQUEST_METHOD'] != "GET" && $_SERVER['REQUEST_METHOD'] != "POST"){

        $json = array(
            'code' => 404,
            'message' => 'API_ERROR_PETICION_INCORRECTA',
            'data' => null
        );

    }

    echo json_encode($json,http_response_code($json["code"]));

    return;
}
