<?php
/**
 * Created by PhpStorm.
 * User: server
 * Date: 23/06/23
 * Time: 09:46 PM
 */

require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/controllers/health_check.controller.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/controllers/bitacora.controller.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/controllers/solicitud_asignacion_set.controller.php";

//notificaciòn telegram
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/libs/telegram.php";

//notificaciòn correo
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/libs/correo2.php";

//Fechas
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/libs/fechas.php";

//header("Access-Control-Allow-Origin: *");
//header("Access-Control-Allow-Methods: POST");

//Valida token
$validaToken = HealthCheckController::validaToken2();
if(!$validaToken[0]) {
    $json = $validaToken[1];
    return;
}

#Save the data

// get posted data
$data = json_decode(file_get_contents("php://input", true));
//var_dump($data);
$response = solicitudAsignacionSetController::saveSolicitud($data);

//var_dump($response);
$folioSisval = str_pad($response[2], 10, "0", STR_PAD_LEFT);

//para bitàcora
$message_tmp = "";
$foliosisval_tmp = "";

if($response[0]){

    $json = array(
        "code" => 200,
        "message" => "SOLICITUD_ASIGNACION_SET_OK",
        "data" => array(
            "folio_proveedor" => $folioSisval
        )
    );

    $message_tmp = "SOLICITUD_ASIGNACION_SET_OK";
    $foliosisval_tmp = $response[2];

}

//Error en la estructura del json
if(!$response[0] && $response[1] == 0){
    $json = array(
        "code" => 400,
        "message" => "API_ERROR_PETICION_INCORRECTA",
        "data" => $response[2]
    );

    $message_tmp = "API_ERROR_PETICION_INCORRECTA";
    $foliosisval_tmp = "";
}

//Error en la consulta a la base de datos
if(!$response[0] && $response[1] == 1){
    $json = array(
        "code" => 400,
        "message" => "API_ERROR_PETICION_INCORRECTA (DB)",
        "data" => $response[2]
    );

    $message_tmp = "API_ERROR_PETICION_INCORRECTA (DB)";
    $foliosisval_tmp = "";
}

//save bitacora
$jsonEntrada = json_encode($data);
$jsonSalida = json_encode($json);
bitacoraController::agregar("bbva_2",$foliosisval_tmp,$message_tmp,$jsonEntrada,$jsonSalida);

//Soporte para agregar a bitácora principal
if(!empty($foliosisval_tmp)){
    bitacoraController::agregarBitP("bbva_2",$foliosisval_tmp,"");

    /*============================
       notificación vía telegram
    *============================*/
     
    //armado del mensaje

    $mensaje = "";

    //encabezado
    $mensaje .= "<b>API (PRUEBAS) BBVA: Asignación de servicio</b>\n\n";
    
    //Folio Sisval Generado
    $mensaje .= "<b>Folio Sisval</b>\n$foliosisval_tmp\n\n";
    
    //Fecha de Asignación
    $fechas_tmp = new fechas();
    $hoy = $fechas_tmp->getFecha('Y-m-d H:i:s');
    $mensaje .= "<b>Fecha de Asignación</b>\n$hoy\n\n";
    
    //Solicitante
    $solicitante = $data->solicitante_nombre." ".$data->solicitante_paterno." ".$data->solicitante_materno;
    $mensaje .= "<b>Nombre del Solicitante</b>\n$solicitante\n\n";

     //Entidad de la Banca
    $entidadesCat = solicitudAsignacionSetController::getCatEntidadesId();
    $idEntidadDesc  = "(".$data->entidades_id.")".$entidadesCat[$data->entidades_id];
    $mensaje .= "<b>Entidad de la Banca</b>\n$idEntidadDesc\n\n";
    
    //Propósito
    $propositos = solicitudAsignacionSetController::getCatPropositos();
    $proposito  = $propositos[$data->finalidades_id];
    $mensaje .= "<b>Propósito</b>\n$proposito\n\n";
    
    //Tipo de servicio
    $tipoServicioCat = solicitudAsignacionSetController::getCatTipoServ();
    $tipoServicio  = $tipoServicioCat[$data->productos_id];
    $mensaje .= "<b>Tipo de Servicio</b>\n$tipoServicio\n\n";

    //Tipo de bien
    $tipoBienes = solicitudAsignacionSetController::getCatTipoBien();
    $tipoBien   = $tipoBienes[$data->tipos_inmueble_id];
    $mensaje .= "<b>Tipo de bien</b>\n$tipoBien\n\n";
    
    //municipio
    $municipio = solicitudAsignacionSetController::getNomMpio(str_pad($data->direcciones->inmueble->nivel1,'2','0',STR_PAD_LEFT),str_pad($data->direcciones->inmueble->nivel2,'3','0',STR_PAD_LEFT));
    $mensaje .= "<b>Municipio</b>\n$municipio\n\n";

    //estado
    $estado = solicitudAsignacionSetController::getNomEdo(str_pad($data->direcciones->inmueble->nivel1,'2','0',STR_PAD_LEFT));
    $mensaje .= "<b>Estado</b>\n$estado\n\n"; 

    //Valor de referencia
    $precioReferencia = number_format($data->precio_valor_estimado,'2','.',',');
    $mensaje .= "<b>Valor de referencia</b>\n$precioReferencia";   
 
    //control
    $chat = "1475467237";
    telegram2::sendNotificacion($chat, $mensaje);

    /*
    //conjuntos
    $chat = "808243788";
    telegram2::sendNotificacion($chat, $mensaje);

    //guias
    $chat = "1632490917";
    telegram2::sendNotificacion($chat, $mensaje);

    //asignacion
    $chat = "1674464810";
    telegram2::sendNotificacion($chat, $mensaje);

    //servicios
    $chat = "1320227528";
    telegram2::sendNotificacion($chat, $mensaje);
    */
    
    //me
    $chat = "74746037";
    telegram2::sendNotificacion($chat, $mensaje);
    
    //Send mail
    sendNotificationMail($foliosisval_tmp,$hoy,$solicitante,$idEntidadDesc,$proposito,$tipoServicio,$tipoBien,$municipio,$estado,$precioReferencia);
    
}

/*=========================================================================
 * Notificación de asignación de servicio a través de correo electrónico.
 * Modified: 07/Mayo/2024 22:02  
 *=========================================================================*/
function sendNotificationMail($foliosisval_tmp,$hoy,$solicitante,$idEntidadDesc,$proposito,$tipoServicio,$tipoBien,$municipio,$estado,$precioReferencia){
    
    $hora_tmp = new fechas();
    $hora = $hora_tmp->getFecha('H');
            
    if ($hora < 12)
        $saludoDesc = "Buenos dias ";

    if ($hora >= 12 && $hora < 19)
        $saludoDesc = "Buenas tardes ";

    if ($hora >= 19 && $hora <= 23)
        $saludoDesc = "Buenas noches ";
    
    //username and passsword
    $username = 'notificaciones@valor.com.mx';
    $password = 'O1_nan?~Ya(!';   
    
    $to = $toC = array();
    
    $to[]  = "control@valor.com.mx";
    $toC[] = "acortes@consoluciones.com.mx";
    
    $content = <<<EOD
<tr>
    <td bgcolor="#ffffff" align="left" style="padding: 0 5px 0 5px;">
        <table border="0" cellpadding="0" cellspacing="0" width="90%"> <!-- style="max-width: 600px;"-->
            <tr>
                <td bgcolor="#ffffff" align="left" style="padding: 0px 0px 0px 0px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">
                    <p style="margin: 0;">
                        {$saludoDesc}
                        <br /><br />
                        Por este medio se le comunica que BBVA API (Ambiente de Pruebas) asignó el siguiente servicio a Valuación Organizada S.A. de C.V.
                        <br /><br />
                    </p>
                </td>
            </tr>
            
            <tr>
                <td bgcolor="#ffffff" align="center" style="padding: 5px 5px 5px 5px;">
                    <table border="2" cellspacing="4" cellpadding="4" style="color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: bold; line-height: 25px;">
                        <tr>
                            <td><b>Folio Sisval</b></td>
                            <td>{$foliosisval_tmp}</td>
                        </tr>
                        <tr>
                            <td><b>Fecha de Asignación</b></td>
                            <td>{$hoy}</td>
                        </tr>
                        <tr>
                            <td><b>Nombre del Solicitante</b></td>
                            <td>{$solicitante}</td>
                        </tr>
                        <tr>
                            <td><b>Entidad de la Banca</b></td>
                            <td>{$idEntidadDesc}</td>
                        </tr>
                        <tr>
                            <td><b>Propósito</b></td>
                            <td>{$proposito}</td>
                        </tr>
                        <tr>
                            <td><b>Tipo de Servicio</b></td>
                            <td>{$tipoServicio}</td>
                        </tr>
                        <tr>
                            <td><b>Tipo de bien</b></td>
                            <td>{$tipoBien}</td>
                        </tr>
                        <tr>
                            <td><b>Municipio</b></td>
                            <td>{$municipio}</td>
                        </tr>
                        <tr>
                            <td><b>Estado</b></td>
                            <td>{$estado}</td>
                        </tr>
                        <tr>
                            <td><b>Valor de Referencia</b></td>
                            <td>{$precioReferencia}</td>
                        </tr>
                    </table>
                </td>     
            </tr> <!-- COPY -->
            
            <tr>
                <td bgcolor="#ffffff" align="center" style="padding: 5px 5px 5px 5px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">
                    <p style="margin: 0;">
                       <b>Saludos</b>
                    </p>
                </td>
            </tr>
            <tr>
                <td bgcolor="#ffffff" align="center" style="padding: 0 30px 40px 30px; border-radius: 0 0 4px 4px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">
                    <img src="http://sisval.com/sisval3/sisval3/img/logo.jpg" width="200" />
                    <p style="margin: 0;">
                        Valuación Organizada S.A. de C.V.
                        <br />
                        Avenida 3 No.1414 Colonia Centro Córdoba Veracruz
                        <br />
                        52 55 8421 0906
                    </p>
                </td>
            </tr>
        </table>
    </td>
</tr>
EOD;

$subject = "API (PRUEBAS) BBVA: Asignación de servicio";
libs\correo2::mandar($to, $toC, $subject, $content, $username, $password);
//echo "La notificación de verificación de campos sostenibles ha sido enviada.<br />";
    
}